/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.client.gui.screens.armorstand;

import com.google.common.collect.Lists;
import fuzs.armorstatues.api.client.gui.components.TickButton;
import fuzs.armorstatues.api.client.gui.components.TickingButton;
import fuzs.armorstatues.api.client.gui.screens.armorstand.ArmorStandWidgetsScreen;
import fuzs.armorstatues.api.network.client.data.DataSyncHandler;
import fuzs.armorstatues.api.world.inventory.ArmorStandHolder;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandAlignment;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandScreenType;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandStyleOptions;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.phys.Vec3;

public class ArmorStandAlignmentsScreen
extends ArmorStandWidgetsScreen {
    public ArmorStandAlignmentsScreen(ArmorStandHolder holder, Inventory inventory, Component component, DataSyncHandler dataSyncHandler) {
        super(holder, inventory, component, dataSyncHandler);
    }

    @Override
    protected List<ArmorStandWidgetsScreen.PositionScreenWidget> buildWidgets(ArmorStand armorStand) {
        ArrayList widgets = Lists.newArrayList((Object[])new ArmorStandWidgetsScreen.PositionScreenWidget[]{new PositionAlignWidget()});
        for (ArmorStandAlignment alignment : ArmorStandAlignment.values()) {
            widgets.add(new AlignmentWidget(alignment));
        }
        return widgets;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new ImageButton(this.leftPos + 6, this.topPos + 6, 20, 20, 136, 64, 20, ARMOR_STAND_WIDGETS_LOCATION, 256, 256, button -> this.f_96541_.m_91152_((Screen)new ConfirmLinkScreen(bl -> {
            if (bl) {
                Util.m_137581_().m_137646_("https://vanillatweaks.net/");
            }
            this.f_96541_.m_91152_((Screen)this);
        }, "https://vanillatweaks.net/", true)), (button, poseStack, mouseX, mouseY) -> this.m_96602_(poseStack, (Component)Component.m_237115_((String)"armorstatues.screen.alignments.credit"), mouseX, mouseY), CommonComponents.f_237098_));
    }

    @Override
    public ArmorStandScreenType getScreenType() {
        return ArmorStandScreenType.ALIGNMENTS;
    }

    private class PositionAlignWidget
    extends BlockPositionWidget {
        private PositionAlignWidget() {
        }

        @Override
        public void init(int posX, int posY) {
            super.init(posX, posY);
            this.children.add((AbstractWidget)ArmorStandAlignmentsScreen.this.m_142416_((GuiEventListener)new TickButton(posX, posY + 1, 94, 20, (Component)Component.m_237115_((String)"armorstatues.screen.position.centered"), (Component)Component.m_237115_((String)"armorstatues.screen.position.aligned"), button -> this.setNewPosition(this.getCurrentPosition().m_82517_(EnumSet.allOf(Direction.Axis.class)).m_82520_(0.5, 0.0, 0.5)))));
            this.children.add((AbstractWidget)ArmorStandAlignmentsScreen.this.m_142416_((GuiEventListener)new TickButton(posX + 100, posY + 1, 94, 20, (Component)Component.m_237115_((String)"armorstatues.screen.position.cornered"), (Component)Component.m_237115_((String)"armorstatues.screen.position.aligned"), button -> this.setNewPosition(this.getCurrentPosition().m_82517_(EnumSet.allOf(Direction.Axis.class))))));
        }
    }

    private class AlignmentWidget
    extends BlockPositionWidget {
        private final ArmorStandAlignment alignment;

        public AlignmentWidget(ArmorStandAlignment alignment) {
            this.alignment = alignment;
        }

        @Override
        public void init(int posX, int posY) {
            super.init(posX, posY);
            this.children.add((AbstractWidget)ArmorStandAlignmentsScreen.this.m_142416_((GuiEventListener)new TickButton(posX, posY + 1, 194, 20, this.alignment.getComponent(), (Component)Component.m_237115_((String)"armorstatues.screen.position.aligned"), button -> {
                ArmorStandAlignmentsScreen.this.dataSyncHandler.sendPose(this.alignment.getPose());
                ArmorStand armorStand = ArmorStandAlignmentsScreen.this.holder.getArmorStand();
                this.setNewPosition(this.getCurrentPosition().m_82517_(EnumSet.allOf(Direction.Axis.class)).m_82520_(0.5, 0.0, 0.5).m_82549_(this.alignment.getPosition(armorStand.m_31666_())));
                if (!armorStand.m_20145_()) {
                    ArmorStandAlignmentsScreen.this.dataSyncHandler.sendStyleOption(ArmorStandStyleOptions.INVISIBLE, true);
                }
                if (!armorStand.m_20068_()) {
                    ArmorStandAlignmentsScreen.this.dataSyncHandler.sendStyleOption(ArmorStandStyleOptions.NO_GRAVITY, true);
                }
            })));
        }
    }

    private abstract class BlockPositionWidget
    extends ArmorStandWidgetsScreen.AbstractPositionScreenWidget {
        public BlockPositionWidget() {
            super(ArmorStandAlignmentsScreen.this, (Component)Component.m_237119_());
        }

        @Override
        public void tick() {
            super.tick();
            for (AbstractWidget widget : this.children) {
                if (!(widget instanceof TickingButton)) continue;
                TickingButton tickButton = (TickingButton)widget;
                tickButton.tick();
            }
        }

        protected Vec3 getCurrentPosition() {
            return ArmorStandAlignmentsScreen.this.holder.getArmorStand().m_20182_();
        }

        protected void setNewPosition(Vec3 vec3) {
            ArmorStandAlignmentsScreen.this.dataSyncHandler.sendPosition(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_());
        }
    }
}

